// Delta.java
// Version 0.4 
// Last Updated: 10/16/2000
//// Used by RecommendationManager

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.


package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import java.sql.*;
import java.math.*;
import oracle.jdbc.driver.*;

import Alkindi.BusinessServices.*;
import Alkindi.BusinessDataTypes.*;

public class Delta{


	double delta=0;
	double[] m;
	int i;

	public double CalcDelta(SystemUser user, int movie_clusterID, double Y1, double Y2, double Y3, double Y4) 
	throws AlkExcept{
	// Y1, Y2, Y3, Y4 are tuning variables
	//
	
		try{
			AlkConn ac = new AlkConn();
			Connection con = ac.getConnection();
		  CallableStatement cs = con.prepareCall("{ call pkg_ALKINDI_RECOMMENDATION.sp_SEL_M_CALCS(?,?,?,?)}");  
		  cs.setLong (1, user.userID);
		  cs.setLong (2, movie_clusterID);  
		  cs.registerOutParameter(3, OracleTypes.CURSOR );
		  cs.registerOutParameter(4, Types.INTEGER );	
		  cs.executeQuery();
		  ResultSet rs = ( (OracleCallableStatement)cs).getCursor(2); 
		  int error = cs.getInt(3);
		  m[0] = rs.getDouble("CALC_M1");
		  m[1] = rs.getDouble("CALC_M2");
		  m[2] = rs.getDouble("CALC_M3");
		  m[3] = rs.getDouble("CALC_M4");
          delta = Y1*m[0] - Y2*m[1] + Y3*m[2] + Y4*m[3]; 
		  rs.close();
		  cs.close();
		  con.close();
 		}
		
		catch(SQLException e){
			throw new AlkExcept("SQL Exception in CalcDelta. Message: " + e.getMessage(), 6004);	
		}

		return delta;
	}
}
